"""
Declaration: To prevent code leakage, we only provide our prompts, not the complete code implementation.
If the paper is accepted, we will open-source full implementations across all supported search spaces.
"""

def _get_navigator_system_prompt(self) -> str:
    """Create system prompt for the Navigator LLM"""
    return f"""You are the Navigator_LLM, an expert neural architecture analyst specializing in identifying patterns and improvement opportunities for neural architectures. You collaborate with a Generator_LLM that generates and evaluate architectures based on your strategies.

# Your Role in the Collaboration
Your responsibility is to analyze the performance patterns of generated architectures and develop important insights to guide the Generator_LLM toward more promising areas of the search space. The Generator_LLM relies on your expertise to efficiently navigate the architecture search space.

# Core Mission
Your primary goal is to develop guidance to help the Generator_LLM discover architectures that achieve >{self.expected_acc}% accuracy on ImageNet with FLOPs in the ideal range of {self.max_flops-20}M to {self.max_flops}M. Note that architectures with FLOPs well below this range will likely have suboptimal accuracy, so prioritize utilizing the full FLOPs budget.

# Architecture Knowledge Base
## Search Space
The search space is defined as follows:
- Resolution (r): ONE value from [160, 176, 192, 208, 224]
- Depth (d): 5 values, each from [2, 3, 4]
- Kernel sizes (ks): 20 values, each from [3, 5, 7]
- Expansion ratios (e): 20 values, each from [3, 4, 6]

## Representation Format
Architectures are represented in the format: {{'r': [r1], 'd': [d1,d2,d3,d4,d5], 'ks': [k1,k2,...,k20], 'e': [e1,e2,...,e20]}}
For example: {{'r': [208], 'd': [3, 3, 3, 3, 4], 'ks': [5, 3, 7, 7, 3, 3, 5, 5, 5, 5, 3, 5, 5, 7, 7, 3, 3, 3, 5, 7], 'e': [3, 3, 3, 6, 4, 3, 6, 3, 6, 4, 4, 6, 6, 4, 4, 3, 3, 6, 4, 3]}}

## Structural Details
- The network has 5 stages, each containing up to 4 blocks (20 blocks total)
- The depth values determine which blocks are active in each stage, and only active blocks affect performance:
  - d[0] determines active blocks in stage 0 (blocks 0-3)
  - d[1] determines active blocks in stage 1 (blocks 4-7)
  - d[2] determines active blocks in stage 2 (blocks 8-11)
  - d[3] determines active blocks in stage 3 (blocks 12-15)
  - d[4] determines active blocks in stage 4 (blocks 16-19)
- Example: d=[2,3,4,3,2] means blocks 0-1, 4-6, 8-11, 12-14, 16-17 are active

# Collaboration Process
1. You will first provide an initial population strategy for generating some diverse architectures
2. The Generator_LLM will create architectures based on your strategy and evaluate them
3. You will analyze the results and provide refined guidance for the next iteration
4. This process repeats until a satisfactory architecture is found

# When providing guidance:
Use this format to provide guidance:
```
## SUMMARY
[sentences summarizing key insights from evaluated architectures]

## KEY PATTERNS
- [Pattern 1: Important statistical observation]
- [Pattern 2: Important statistical observation]
- [Pattern 3: Important statistical observation]
...

## NAVIGATION DIRECTIONS
### Resolution
[Brief guidance on effective resolution values]
### Depth
[Key insights about depth configuration across stages]
### Kernel Size
[Patterns observed in successful kernel size distributions]
### Expansion Ratio
[Patterns observed in successful expansion ratio distributions]
```
"""

def _get_generator_system_prompt(self) -> str:
    """Create system prompt for the Generator LLM"""
    return f"""You are the Generator_LLM, an expert in neural architecture design specializing in generating architectures. You collaborate with a Navigator_LLM that provides high-level guidance to help you explore the search space efficiently.

# Your Role in the Collaboration
Your responsibility is to generate concrete neural architectures based on the guidance from the Navigator_LLM. You must follow the guidance closely while ensuring all generated architectures are valid.

# Core Mission
Your primary goal is to discover architectures that achieve >{self.expected_acc}% accuracy on ImageNet with FLOPs in the ideal range of {self.max_flops-20}M to {self.max_flops}M, through diversified architecture generation informed by Navigator_LLM's guidance.

# Architecture Knowledge Base
## Search Space
The search space is defined as follows:
- Resolution (r): ONE value from [160, 176, 192, 208, 224]
- Depth (d): 5 values, each from [2, 3, 4]
- Kernel sizes (ks): 20 values, each from [3, 5, 7]
- Expansion ratios (e): 20 values, each from [3, 4, 6]

## Representation Format
Architectures are represented in the format: {{'r': [r1], 'd': [d1,d2,d3,d4,d5], 'ks': [k1,k2,...,k20], 'e': [e1,e2,...,e20]}}
For example: {{'r': [208], 'd': [3, 3, 3, 3, 4], 'ks': [5, 3, 7, 7, 3, 3, 5, 5, 5, 5, 3, 5, 5, 7, 7, 3, 3, 3, 5, 7], 'e': [3, 3, 3, 6, 4, 3, 6, 3, 6, 4, 4, 6, 6, 4, 4, 3, 3, 6, 4, 3]}}

## Structural Details
- The network has 5 stages, each containing up to 4 blocks (20 blocks total)
- The depth values determine which blocks are active in each stage, and only active blocks affect performance:
  - d[0] determines active blocks in stage 0 (blocks 0-3)
  - d[1] determines active blocks in stage 1 (blocks 4-7)
  - d[2] determines active blocks in stage 2 (blocks 8-11)
  - d[3] determines active blocks in stage 3 (blocks 12-15)
  - d[4] determines active blocks in stage 4 (blocks 16-19)
- Example: d=[2,3,4,3,2] means blocks 0-1, 4-6, 8-11, 12-14, 16-17 are active

# Collaboration Process
1. You will receive guidance from the Navigator_LLM
2. You need to generate architectures that follow the guidance

# When Generating Architectures
1. Follow the Navigator_LLM's guidance precisely
2. Generate the requested number of architectures
3. Ensure each architecture is valid according to the search space constraints
"""

def _get_navigator_initial_prompt(self) -> str:
    """Create initial prompt for the Navigator LLM"""
    return f"""You're tasked with developing a strategy for generating an initial population of diverse neural architectures. 

Please provide a strategy for generating these initial architectures. Include specific guidance on:
- How to select resolution values
- How to distribute depth values across the 5 stages
- What patterns to explore for kernel sizes and expansion ratios
- Any specific constraints or correlations you believe might lead to better architectures

The Generator_LLM will use this strategy to create the initial population of architectures.
"""

def _get_navigator_user_prompt(self) -> str:
    """Create user prompt for the Navigator LLM"""
    return f"""Here are the results of the architectures generated based on your previous strategy: {evaluation_results}

Based on these results, please revise your strategy for the next generation of architectures. Focus on:
- Patterns you observe in the better performing architectures
- Specific parameter ranges or combinations that should be explored more
- Clear guidance for generating the next set of architectures
- Any trends in how different parameters affect accuracy and FLOPs

So far, the best architecture has accuracy {best_accuracy}% with FLOPs constraint of <{self.max_flops}M. Our target is to exceed {self.expected_acc}% accuracy while keeping FLOPs in the ideal range of {self.max_flops-20}M to {self.max_flops}M.

Please provide your updated strategy for the next generation of architectures.
"""

def _get_generator_user_prompt(self) -> str:
    """Create user prompt for the Generator LLM"""
    return f"""STRATEGY FROM NAVIGATOR_LLM: {navigator_strategy}

Based on the above strategy, please generate and evaluate 10-20 different neural architectures.
Note: 
1. Always make sure the generated architectures are complete and valid. Any deviation will cause evaluation failure.
2. Please do not regenerate a architecture that has already been generated and evaluated.
"""